/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.output;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.blame.SourceFragmentPositionRange;
import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;

public class GradleMessage {
    @SerializedName(value="kind")
    @NonNull
    private final Kind mKind;
    @SerializedName(value="text")
    @NonNull
    private final String mText;
    @SerializedName(value="sourcePath")
    @Nullable
    private final String mSourcePath;
    @SerializedName(value="position")
    @NonNull
    private final SourceFragmentPositionRange mPosition;
    @SerializedName(value="original")
    @NonNull
    private final String mOriginal;

    public GradleMessage(@NonNull Kind kind, @NonNull String text) {
        this(kind, text, null, new SourceFragmentPositionRange(), text);
    }

    public GradleMessage(@NonNull Kind kind, @NonNull String text, @Nullable String sourcePath, @NonNull SourceFragmentPositionRange position, @NonNull String original) {
        this.mKind = kind;
        this.mText = text;
        this.mSourcePath = sourcePath;
        this.mPosition = position;
        this.mOriginal = original;
    }

    public GradleMessage(@NonNull Kind kind, @NonNull String text, @Nullable String sourcePath, int line, int column) {
        this(kind, text, sourcePath, new SourceFragmentPositionRange(line, column, -1), text);
    }

    @NonNull
    public Kind getKind() {
        return this.mKind;
    }

    @NonNull
    public String getText() {
        return this.mText;
    }

    @Nullable
    public String getSourcePath() {
        return this.mSourcePath;
    }

    public int getLineNumber() {
        return this.mPosition.getStartLine();
    }

    public int getColumn() {
        return this.mPosition.getStartColumn();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GradleMessage that = (GradleMessage)o;
        return Objects.equal((Object)this.mPosition, (Object)that.mPosition) && this.mKind == that.mKind && Objects.equal((Object)this.mSourcePath, (Object)that.mSourcePath) && Objects.equal((Object)this.mText, (Object)that.mText);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mPosition, this.mKind, this.mSourcePath, this.mText});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "kind=" + (Object)((Object)this.mKind) + ", text=\"" + this.mText + '\"' + ", sourcePath=" + this.mSourcePath + ", position=" + this.mPosition.toString() + ']';
    }

    public SourceFragmentPositionRange getPosition() {
        return this.mPosition;
    }

    public String getOriginal() {
        return this.mOriginal;
    }

    public static enum Kind {
        ERROR,
        WARNING,
        INFO,
        STATISTICS,
        SIMPLE;


        @Nullable
        public static Kind findIgnoringCase(@NonNull String s) {
            for (Kind kind : Kind.values()) {
                if (!kind.toString().equalsIgnoreCase(s)) continue;
                return kind;
            }
            return null;
        }
    }
}

