/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser.aapt;

import com.android.annotations.NonNull;
import com.android.ide.common.blame.output.GradleMessage;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.aapt.AbstractAaptOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Error5Parser
extends AbstractAaptOutputParser {
    private static final List<Pattern> MSG_PATTERNS = ImmutableList.of((Object)Pattern.compile("^(.+?):(\\d+): error: Error:\\s+(.+)$"), (Object)Pattern.compile("^(.+?):(\\d+): error:\\s+(.+)$"), (Object)Pattern.compile("^(.+?):(\\d+):\\s+(.+)$"));

    Error5Parser() {
    }

    @Override
    public boolean parse(@NonNull String line, @NonNull OutputLineReader reader, @NonNull List<GradleMessage> messages, @NonNull ILogger logger) throws ParsingFailedException {
        for (Pattern pattern : MSG_PATTERNS) {
            Matcher m = pattern.matcher(line);
            if (!m.matches()) continue;
            String sourcePath = m.group(1);
            String lineNumber = m.group(2);
            String msgText = m.group(3);
            GradleMessage.Kind kind = GradleMessage.Kind.ERROR;
            if (msgText.startsWith("warning: ")) {
                kind = GradleMessage.Kind.WARNING;
            }
            if (sourcePath.endsWith(".java")) {
                return false;
            }
            GradleMessage msg = this.createMessage(kind, msgText, sourcePath, lineNumber, "", logger);
            messages.add(msg);
            return true;
        }
        return false;
    }
}

