/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.junit;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.JUnitCorePlugin;
import org.eclipse.jdt.internal.junit.launcher.JUnit4TestFinder;
import org.eclipse.jdt.internal.junit.model.JUnitModel;
import org.eclipse.jdt.internal.junit.model.ModelMessages;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.junit.ITestRunListener;
import org.eclipse.jdt.junit.TestRunListener;
import org.eclipse.jdt.junit.model.ITestRunSession;

public class JUnitCore {
    public static final String JUNIT_CONTAINER_ID = "org.eclipse.jdt.junit.JUNIT_CONTAINER";
    public static final IPath JUNIT3_CONTAINER_PATH = new Path("org.eclipse.jdt.junit.JUNIT_CONTAINER").append("3");
    public static final IPath JUNIT4_CONTAINER_PATH = new Path("org.eclipse.jdt.junit.JUNIT_CONTAINER").append("4");

    public static void addTestRunListener(ITestRunListener listener) {
        JUnitCorePlugin.getDefault().addTestRunListener(listener);
    }

    public static void removeTestRunListener(ITestRunListener listener) {
        JUnitCorePlugin.getDefault().removeTestRunListener(listener);
    }

    public static void addTestRunListener(TestRunListener listener) {
        JUnitCorePlugin.getDefault().getNewTestRunListeners().add((Object)listener);
    }

    public static void removeTestRunListener(TestRunListener listener) {
        JUnitCorePlugin.getDefault().getNewTestRunListeners().remove((Object)listener);
    }

    public static IType[] findTestTypes(IJavaElement container, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        HashSet result = new HashSet();
        JUnit4TestFinder finder = new JUnit4TestFinder();
        finder.findTestsInContainer(container, result, monitor);
        return result.toArray(new IType[result.size()]);
    }

    public static void exportTestRunSession(ITestRunSession testRunSession, File file) throws CoreException {
        JUnitModel.exportTestRunSession((TestRunSession)testRunSession, file);
    }

    public static void exportTestRunSession(ITestRunSession testRunSession, OutputStream output) throws CoreException {
        try {
            JUnitModel.exportTestRunSession((TestRunSession)testRunSession, output);
        }
        catch (TransformerException exception) {
            String pluginID = JUnitCorePlugin.getPluginId();
            String message = ModelMessages.JUnitModel_could_not_export;
            throw new CoreException((IStatus)new Status(4, pluginID, message, (Throwable)exception));
        }
    }

    public static ITestRunSession importTestRunSession(File file) throws CoreException {
        return JUnitModel.importTestRunSession(file);
    }

    public static ITestRunSession importTestRunSession(String url, IProgressMonitor monitor) throws CoreException {
        try {
            return JUnitModel.importTestRunSession(url, monitor);
        }
        catch (InvocationTargetException exception) {
            String pluginID = JUnitCorePlugin.getPluginId();
            String message = ModelMessages.JUnitModel_could_not_import;
            Throwable throwable = exception.getCause() != null ? exception.getCause() : exception;
            throw new CoreException((IStatus)new Status(4, pluginID, message, throwable));
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }
}

