/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.op.ResetOperation;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.dialogs.ResetTargetSelectionDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class ResetActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(true, event);
        if (repository == null) {
            return null;
        }
        if (!repository.getRepositoryState().canResetHead()) {
            MessageDialog.openError((Shell)this.getShell(event), (String)UIText.ResetAction_errorResettingHead, (String)NLS.bind((String)UIText.ResetAction_repositoryState, (Object)repository.getRepositoryState().getDescription()));
            return null;
        }
        ResetTargetSelectionDialog branchSelectionDialog = new ResetTargetSelectionDialog(this.getShell(event), repository);
        if (branchSelectionDialog.open() == 0) {
            String refName = branchSelectionDialog.getRefName();
            ResetCommand.ResetType type = branchSelectionDialog.getResetType();
            String jobname = NLS.bind((String)UIText.ResetAction_reset, (Object)refName);
            ResetOperation operation = new ResetOperation(repository, refName, type);
            JobUtil.scheduleUserWorkspaceJob((IEGitOperation)operation, (String)jobname, (Object)JobFamilies.RESET);
        }
        return null;
    }

    public boolean isEnabled() {
        Repository repo = this.getRepository();
        return repo != null && this.containsHead(repo);
    }
}

