/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.push.AddRemotePage;
import org.eclipse.egit.ui.internal.push.ConfirmationPage;
import org.eclipse.egit.ui.internal.push.PushBranchPage;
import org.eclipse.egit.ui.internal.push.PushOperationUI;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushBranchWizard
extends Wizard {
    private final Repository repository;
    private final Ref refToPush;
    private AddRemotePage addRemotePage;
    private PushBranchPage pushBranchPage;
    private ConfirmationPage confirmationPage;

    public PushBranchWizard(Repository repository, Ref refToPush) {
        this.repository = repository;
        this.refToPush = refToPush;
        Set remoteNames = repository.getConfig().getSubsections("remote");
        if (remoteNames.isEmpty()) {
            this.addRemotePage = new AddRemotePage(repository);
        }
        this.pushBranchPage = new PushBranchPage(repository, refToPush){

            public void setVisible(boolean visible) {
                if (visible && PushBranchWizard.this.addRemotePage != null) {
                    this.setSelectedRemote(PushBranchWizard.this.addRemotePage.getRemoteName(), PushBranchWizard.this.addRemotePage.getSelection().getURI());
                }
                super.setVisible(visible);
            }
        };
        this.pushBranchPage.setShowNewRemoteButton(this.addRemotePage == null);
        this.confirmationPage = new ConfirmationPage(repository){

            public void setVisible(boolean visible) {
                this.setSelection(PushBranchWizard.this.getRepositorySelection(), PushBranchWizard.this.getRefSpecs());
                AddRemotePage remotePage = PushBranchWizard.this.getAddRemotePage();
                if (remotePage != null) {
                    this.setCredentials(remotePage.getCredentials());
                }
                super.setVisible(visible);
            }
        };
    }

    public void addPages() {
        if (this.addRemotePage != null) {
            this.addPage((IWizardPage)this.addRemotePage);
        }
        this.addPage((IWizardPage)this.pushBranchPage);
        this.addPage((IWizardPage)this.confirmationPage);
    }

    public String getWindowTitle() {
        return MessageFormat.format(UIText.PushBranchWizard_WindowTitle, Repository.shortenRefName((String)this.refToPush.getName()));
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.confirmationPage;
    }

    public boolean performFinish() {
        try {
            AddRemotePage remotePage = this.getAddRemotePage();
            if (remotePage != null) {
                this.storeCredentials(remotePage);
                URIish uri = remotePage.getSelection().getURI();
                this.configureNewRemote(uri);
            }
            if (this.pushBranchPage.isConfigureUpstreamSelected()) {
                this.configureUpstream();
            }
            this.startPush();
        }
        catch (IOException e) {
            this.confirmationPage.setErrorMessage(e.getMessage());
            return false;
        }
        catch (URISyntaxException e) {
            this.confirmationPage.setErrorMessage(e.getMessage());
            return false;
        }
        return true;
    }

    private AddRemotePage getAddRemotePage() {
        if (this.addRemotePage != null) {
            return this.addRemotePage;
        }
        return this.pushBranchPage.getAddRemotePage();
    }

    private RepositorySelection getRepositorySelection() {
        AddRemotePage remotePage = this.getAddRemotePage();
        if (remotePage != null) {
            return remotePage.getSelection();
        }
        return new RepositorySelection(null, this.pushBranchPage.getRemoteConfig());
    }

    private List<RefSpec> getRefSpecs() {
        String src = this.refToPush.getName();
        String dst = "refs/heads/" + this.pushBranchPage.getBranchName();
        RefSpec refSpec = new RefSpec().setSourceDestination(src, dst).setForceUpdate(this.pushBranchPage.isForceUpdateSelected());
        return Arrays.asList(refSpec);
    }

    private void storeCredentials(AddRemotePage remotePage) {
        URIish uri;
        if (remotePage.getStoreInSecureStore() && (uri = remotePage.getSelection().getURI()) != null) {
            SecureStoreUtils.storeCredentials(remotePage.getCredentials(), uri);
        }
    }

    private void configureNewRemote(URIish uri) throws URISyntaxException, IOException {
        StoredConfig config = this.repository.getConfig();
        String remoteName = this.getRemoteName();
        RemoteConfig remoteConfig = new RemoteConfig((Config)config, remoteName);
        remoteConfig.addURI(uri);
        RefSpec defaultFetchSpec = new RefSpec().setForceUpdate(true).setSourceDestination("refs/heads/*", "refs/remotes/" + remoteName + "/*");
        remoteConfig.addFetchRefSpec(defaultFetchSpec);
        remoteConfig.update((Config)config);
        config.save();
    }

    private void configureUpstream() throws IOException {
        String remoteName = this.getRemoteName();
        String remoteBranchName = this.pushBranchPage.getBranchName();
        String branchName = Repository.shortenRefName((String)this.refToPush.getName());
        StoredConfig config = this.repository.getConfig();
        config.setString("branch", branchName, "remote", remoteName);
        config.setString("branch", branchName, "merge", "refs/heads/" + remoteBranchName);
        if (this.pushBranchPage.isRebaseSelected()) {
            config.setBoolean("branch", branchName, "rebase", true);
        } else {
            config.unset("branch", branchName, "rebase");
        }
        config.save();
    }

    private void startPush() throws IOException {
        PushOperationResult result = this.confirmationPage.getConfirmedResult();
        PushOperationSpecification pushSpec = result.deriveSpecification(this.confirmationPage.isRequireUnchangedSelected());
        PushOperationUI pushOperationUI = new PushOperationUI(this.repository, pushSpec, false);
        pushOperationUI.setCredentialsProvider(new EGitCredentialsProvider());
        pushOperationUI.setShowConfigureButton(false);
        if (this.confirmationPage.isShowOnlyIfChangedSelected()) {
            pushOperationUI.setExpectedResult(result);
        }
        pushOperationUI.start();
    }

    private String getRemoteName() {
        return this.pushBranchPage.getRemoteConfig().getName();
    }
}

