/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.egit.core.op.PushOperation;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.components.RefContentAssistProvider;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.egit.ui.internal.components.SimplePushSpecPage;
import org.eclipse.egit.ui.internal.push.PushWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;

public class SimplePushRefWizard
extends Wizard {
    private ObjectId pushObj;
    private RepositorySelectionPage repoPage;
    private String nicePushName;
    private Repository repo;
    private SimplePushSpecPage targetPage;

    public SimplePushRefWizard(Repository repo, Ref refToPush, String title) throws URISyntaxException {
        this(repo, refToPush.getObjectId(), refToPush.getName(), title);
    }

    public SimplePushRefWizard(Repository repo, ObjectId objectId, String title) throws URISyntaxException {
        this(repo, objectId, AbbreviatedObjectId.fromObjectId((AnyObjectId)objectId).name(), title);
    }

    private SimplePushRefWizard(Repository repo, ObjectId objectId, String name, String title) throws URISyntaxException {
        List remotes = RemoteConfig.getAllRemoteConfigs((Config)repo.getConfig());
        this.nicePushName = name;
        this.pushObj = objectId;
        this.repo = repo;
        this.repoPage = new RepositorySelectionPage(false, remotes, null);
        this.targetPage = new SimplePushSpecPage(this.nicePushName, repo){

            public void setVisible(boolean visible) {
                super.setVisible(visible);
                if (visible) {
                    try {
                        if (this.assist != null && this.assist.getRepository().equals(SimplePushRefWizard.this.repo) && this.assist.getRemoteURI().equals((Object)SimplePushRefWizard.this.repoPage.getSelection().getURI(true))) {
                            return;
                        }
                        this.assist = new RefContentAssistProvider(SimplePushRefWizard.this.repo, SimplePushRefWizard.this.repoPage.getSelection().getURI(true), this.getShell());
                    }
                    finally {
                        this.updateDestinationField();
                    }
                }
            }
        };
        this.setWindowTitle(title);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.repoPage);
        this.addPage((IWizardPage)this.targetPage);
    }

    public boolean performFinish() {
        try {
            int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
            PushOperationSpecification specification = new PushOperationSpecification();
            RepositorySelection remote = this.repoPage.getSelection();
            RefSpec refSpec = new RefSpec().setSourceDestination(this.pushObj.name(), this.targetPage.getTargetRef()).setForceUpdate(this.targetPage.isForceUpdate());
            RemoteConfig remoteConfig = remote.getConfig();
            List fetchSpecs = remoteConfig != null ? remoteConfig.getFetchRefSpecs() : null;
            Collection remoteRefUpdates = Transport.findRemoteRefUpdatesFor((Repository)this.repo, Collections.singleton(refSpec), (Collection)fetchSpecs);
            specification.addURIRefUpdates(remote.getURI(true), remoteRefUpdates);
            PushOperation pop = new PushOperation(this.repo, specification, false, timeout);
            PushWizard.PushJob job = new PushWizard.PushJob(this.repo, pop, null, PushWizard.getDestinationString(remote));
            job.setUser(true);
            job.schedule();
            this.repoPage.saveUriInPrefs();
        }
        catch (Exception e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        return true;
    }
}

