/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.plugin.AbstractPluginElementDetails;
import org.eclipse.pde.internal.ui.editor.plugin.rows.BooleanAttributeRow;
import org.eclipse.pde.internal.ui.editor.plugin.rows.ChoiceAttributeRow;
import org.eclipse.pde.internal.ui.editor.plugin.rows.ClassAttributeRow;
import org.eclipse.pde.internal.ui.editor.plugin.rows.ExtensionAttributeRow;
import org.eclipse.pde.internal.ui.editor.plugin.rows.IdAttributeRow;
import org.eclipse.pde.internal.ui.editor.plugin.rows.ResourceAttributeRow;
import org.eclipse.pde.internal.ui.editor.plugin.rows.TextAttributeRow;
import org.eclipse.pde.internal.ui.editor.plugin.rows.TranslatableAttributeRow;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class ExtensionElementDetails
extends AbstractPluginElementDetails {
    private IPluginElement input;
    private ISchemaElement schemaElement;
    private ArrayList<ExtensionAttributeRow> rows;
    private Section section;

    public ExtensionElementDetails(PDESection masterSection, ISchemaElement schemaElement) {
        super(masterSection);
        this.schemaElement = schemaElement;
        this.rows = new ArrayList();
    }

    @Override
    public String getContextId() {
        return "plugin-context";
    }

    @Override
    public void fireSaveNeeded() {
        this.markDirty();
        this.getPage().getPDEEditor().fireSaveNeeded(this.getContextId(), false);
    }

    @Override
    public PDEFormPage getPage() {
        return (PDEFormPage)((Object)this.getManagedForm().getContainer());
    }

    @Override
    public boolean isEditable() {
        return this.getPage().getPDEEditor().getAggregateModel().isEditable();
    }

    public void createContents(Composite parent) {
        parent.setLayout((Layout)FormLayoutFactory.createDetailsGridLayout(false, 1));
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        this.section = toolkit.createSection(parent, 384);
        this.section.clientVerticalSpacing = 6;
        this.section.setText(PDEUIMessages.ExtensionElementDetails_title);
        this.section.setDescription("");
        this.section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        this.section.setLayoutData((Object)new GridData(1810));
        this.getPage().alignSectionHeaders(this.getMasterSection().getSection(), this.section);
        Composite client = toolkit.createComposite((Composite)this.section);
        int span = 2;
        GridLayout glayout = FormLayoutFactory.createSectionClientGridLayout(false, span);
        client.setLayout((Layout)glayout);
        client.setLayoutData((Object)new GridData(768));
        if (this.schemaElement != null) {
            int i;
            ISchemaAttribute[] atts = this.schemaElement.getAttributes();
            if (this.isEditable()) {
                i = 0;
                while (i < atts.length) {
                    if (atts[i].getKind() == 1 || atts[i].getKind() == 2 || atts[i].getKind() == 3) {
                        span = 3;
                        break;
                    }
                    ++i;
                }
            }
            glayout.numColumns = span;
            i = 0;
            while (i < atts.length) {
                if (atts[i].getUse() == 1) {
                    this.rows.add(this.createAttributeRow(atts[i], client, toolkit, span));
                }
                ++i;
            }
            i = 0;
            while (i < atts.length) {
                if (atts[i].getUse() != 1) {
                    this.rows.add(this.createAttributeRow(atts[i], client, toolkit, span));
                }
                ++i;
            }
            this.createSpacer(toolkit, client, span);
        }
        toolkit.paintBordersFor(client);
        this.section.setClient((Control)client);
        this.getPage().addLastFocusListeners(client);
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        model.addModelChangedListener((IModelChangedListener)this);
        this.markDetailsPart((Control)this.section);
    }

    private ExtensionAttributeRow createAttributeRow(ISchemaAttribute att, Composite parent, FormToolkit toolkit, int span) {
        ISchemaRestriction restriction;
        ISchemaSimpleType type;
        ExtensionAttributeRow row = att.getKind() == 1 ? new ClassAttributeRow((IContextPart)this, att) : (att.getKind() == 2 ? new ResourceAttributeRow((IContextPart)this, att) : (att.getKind() == 3 ? new IdAttributeRow((IContextPart)this, att) : (att.isTranslatable() ? new TranslatableAttributeRow((IContextPart)this, att) : ((type = att.getType()).getName().equals("boolean") ? new BooleanAttributeRow((IContextPart)this, att) : ((restriction = type.getRestriction()) != null ? new ChoiceAttributeRow((IContextPart)this, att) : new TextAttributeRow((IContextPart)this, att))))));
        ((ExtensionAttributeRow)row).createContents(parent, toolkit, span);
        return row;
    }

    private ExtensionAttributeRow createAttributeRow(IPluginAttribute att, Composite parent, FormToolkit toolkit, int span) {
        TextAttributeRow row = new TextAttributeRow((IContextPart)this, att);
        ((ExtensionAttributeRow)row).createContents(parent, toolkit, span);
        return row;
    }

    public void selectionChanged(IFormPart masterPart, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.input = ssel.size() == 1 ? (IPluginElement)ssel.getFirstElement() : null;
        this.update();
    }

    public void modelChanged(IModelChangedEvent e) {
        Object obj;
        if (e.getChangeType() == 3 && (obj = e.getChangedObjects()[0]).equals(this.input)) {
            String property = e.getChangedProperty();
            if (property != null) {
                int i = 0;
                while (i < this.rows.size()) {
                    String name;
                    ExtensionAttributeRow row = this.rows.get(i);
                    ISchemaAttribute attribute = row.getAttribute();
                    if (attribute != null && (name = attribute.getName()) != null && name.equals(property)) {
                        row.setInput(this.input);
                    }
                    ++i;
                }
            } else {
                this.refresh();
            }
        }
    }

    private void update() {
        this.updateDescription();
        if (this.schemaElement == null) {
            this.updateRows();
        }
        int i = 0;
        while (i < this.rows.size()) {
            ExtensionAttributeRow row = this.rows.get(i);
            row.setInput(this.input);
            ++i;
        }
    }

    private void updateRows() {
        if (this.input == null) {
            return;
        }
        IPluginAttribute[] atts = this.input.getAttributes();
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        boolean rowsAdded = false;
        int i = 0;
        while (i < atts.length) {
            if (!this.hasAttribute(atts[i].getName())) {
                this.rows.add(this.createAttributeRow(atts[i], (Composite)this.section.getClient(), toolkit, 2));
                rowsAdded = true;
            }
            ++i;
        }
        if (rowsAdded) {
            ((Composite)this.section.getClient()).layout(true);
            this.section.layout(true);
            this.section.getParent().layout(true);
            this.reflow();
        }
    }

    private void reflow() {
        Composite parent = this.section.getParent();
        while (parent != null) {
            if (parent instanceof SharedScrolledComposite) {
                ((SharedScrolledComposite)parent).reflow(true);
                return;
            }
            parent = parent.getParent();
        }
    }

    private boolean hasAttribute(String attName) {
        int i = 0;
        while (i < this.rows.size()) {
            ExtensionAttributeRow row = this.rows.get(i);
            if (row.getName().equals(attName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void updateDescription() {
        if (this.input != null) {
            String iname = this.input.getName();
            String label = null;
            label = this.input.getAttributeCount() == 0 ? PDEUIMessages.ExtensionElementDetails_descNoAttributes : (this.schemaElement.hasDeprecatedAttributes() ? NLS.bind((String)PDEUIMessages.ExtensionElementDetails_setDescDepr, (Object)iname) : NLS.bind((String)PDEUIMessages.ExtensionElementDetails_setDesc, (Object)iname));
            if (this.schemaElement.isDeprecated()) {
                label = String.valueOf(label) + "\n\n";
                label = String.valueOf(label) + NLS.bind((String)PDEUIMessages.ElementIsDeprecated, (Object)iname);
            }
            this.section.setDescription(label);
        } else {
            this.section.setDescription("");
        }
        this.section.layout();
    }

    public void commit(boolean onSave) {
        int i = 0;
        while (i < this.rows.size()) {
            ExtensionAttributeRow row = this.rows.get(i);
            row.commit();
            ++i;
        }
        super.commit(onSave);
    }

    public void setFocus() {
        if (this.rows.size() > 0) {
            this.rows.get(0).setFocus();
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.rows.size()) {
            ExtensionAttributeRow row = this.rows.get(i);
            row.dispose();
            ++i;
        }
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void refresh() {
        this.update();
        super.refresh();
    }
}

