/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.filesystem;

import java.net.URI;
import java.util.HashMap;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.filesystem.CVSFileStore;
import org.eclipse.team.internal.ccvs.core.filesystem.CVSFileTree;
import org.eclipse.team.internal.ccvs.core.filesystem.CVSURI;
import org.eclipse.team.internal.ccvs.core.filesystem.RemoteLogger;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;

public class CVSFileSystem
extends FileSystem {
    private CVSFileTree cvsTree;

    public IFileStore getStore(URI uri) {
        return new CVSFileStore(CVSURI.fromUri(uri), null);
    }

    public boolean canReturnFullTree() {
        return true;
    }

    public CVSFileTree getFullTree(URI uri, IProgressMonitor monitor) {
        try {
            monitor.beginTask(CVSMessages.CVSFileSystem_FetchTree, 100);
            if (this.cvsTree != null) {
                CVSFileTree cVSFileTree = this.cvsTree;
                return cVSFileTree;
            }
            CVSFileTree cVSFileTree = this.refreshTree(uri, monitor);
            return cVSFileTree;
        }
        finally {
            monitor.done();
        }
    }

    public CVSFileTree refreshTree(URI uri, IProgressMonitor monitor) {
        CVSURI cvsURI = CVSURI.fromUri(uri);
        ICVSRemoteFolder folder = cvsURI.getProjectURI().toFolder();
        try {
            RemoteLogger logger = new RemoteLogger(folder);
            RemoteFolderTree remoteTree = logger.fetchTree((IProgressMonitor)new SubProgressMonitor(monitor, 80));
            HashMap folderMap = logger.getFolderMap();
            HashMap logMap = logger.getLogMap();
            folderMap.put(folder.getName(), remoteTree);
            this.cvsTree = new CVSFileTree((IFileStore)new CVSFileStore(cvsURI, null), cvsURI, remoteTree, folderMap, logMap);
            return this.cvsTree;
        }
        catch (CoreException e) {
            CVSProviderPlugin.log(e);
            return null;
        }
    }
}

