/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.IFileExporter;
import org.eclipse.ui.internal.wizards.datatransfer.TarFileExporter;
import org.eclipse.ui.internal.wizards.datatransfer.ZipFileExporter;

public class ArchiveFileExportOperation
implements IRunnableWithProgress {
    private IFileExporter exporter;
    private String destinationFilename;
    private IProgressMonitor monitor;
    private List resourcesToExport;
    private IResource resource;
    private List errorTable = new ArrayList(1);
    private boolean useCompression = true;
    private boolean useTarFormat = false;
    private boolean createLeadupStructure = true;

    public ArchiveFileExportOperation(List resources, String filename) {
        Iterator elementsEnum = resources.iterator();
        while (elementsEnum.hasNext()) {
            IResource currentResource = (IResource)elementsEnum.next();
            if (!this.isDescendent(resources, currentResource)) continue;
            elementsEnum.remove();
        }
        this.resourcesToExport = resources;
        this.destinationFilename = filename;
    }

    public ArchiveFileExportOperation(IResource res, String filename) {
        this.resource = res;
        this.destinationFilename = filename;
    }

    public ArchiveFileExportOperation(IResource res, List resources, String filename) {
        this(res, filename);
        this.resourcesToExport = resources;
    }

    protected void addError(String message, Throwable e) {
        this.errorTable.add(new Status(4, "org.eclipse.ui.ide", 0, message, e));
    }

    protected int countChildrenOf(IResource checkResource) throws CoreException {
        if (checkResource.getType() == 1) {
            return 1;
        }
        int count = 0;
        if (checkResource.isAccessible()) {
            IResource[] children = ((IContainer)checkResource).members();
            int i = 0;
            while (i < children.length) {
                count += this.countChildrenOf(children[i]);
                ++i;
            }
        }
        return count;
    }

    protected int countSelectedResources() throws CoreException {
        int result = 0;
        Iterator resources = this.resourcesToExport.iterator();
        while (resources.hasNext()) {
            result += this.countChildrenOf((IResource)resources.next());
        }
        return result;
    }

    protected void exportResource(IResource exportResource) throws InterruptedException {
        this.exportResource(exportResource, 1);
    }

    private String createDestinationName(int leadupDepth, IResource exportResource) {
        IPath fullPath = exportResource.getFullPath();
        if (this.createLeadupStructure) {
            return fullPath.makeRelative().toString();
        }
        return fullPath.removeFirstSegments(fullPath.segmentCount() - leadupDepth).toString();
    }

    protected void exportResource(IResource exportResource, int leadupDepth) throws InterruptedException {
        if (!exportResource.isAccessible()) {
            return;
        }
        if (exportResource.getType() == 1) {
            String destinationName = this.createDestinationName(leadupDepth, exportResource);
            this.monitor.subTask(destinationName);
            try {
                this.exporter.write((IFile)exportResource, destinationName);
            }
            catch (IOException e) {
                this.addError(NLS.bind((String)DataTransferMessages.DataTransfer_errorExporting, (Object)exportResource.getFullPath().makeRelative(), (Object)e.getMessage()), e);
            }
            catch (CoreException e) {
                this.addError(NLS.bind((String)DataTransferMessages.DataTransfer_errorExporting, (Object)exportResource.getFullPath().makeRelative(), (Object)e.getMessage()), e);
            }
            this.monitor.worked(1);
            ModalContext.checkCanceled((IProgressMonitor)this.monitor);
        } else {
            IResource[] children = null;
            try {
                children = ((IContainer)exportResource).members();
            }
            catch (CoreException e) {
                this.addError(NLS.bind((String)DataTransferMessages.DataTransfer_errorExporting, (Object)exportResource.getFullPath()), e);
            }
            if (children.length == 0) {
                String destinationName = this.createDestinationName(leadupDepth, exportResource);
                try {
                    this.exporter.write((IContainer)exportResource, String.valueOf(destinationName) + '/');
                }
                catch (IOException e) {
                    this.addError(NLS.bind((String)DataTransferMessages.DataTransfer_errorExporting, (Object)exportResource.getFullPath().makeRelative(), (Object)e.getMessage()), e);
                }
            }
            int i = 0;
            while (i < children.length) {
                this.exportResource(children[i], leadupDepth + 1);
                ++i;
            }
        }
    }

    protected void exportSpecifiedResources() throws InterruptedException {
        for (IResource currentResource : this.resourcesToExport) {
            this.exportResource(currentResource);
        }
    }

    public IStatus getStatus() {
        IStatus[] errors = new IStatus[this.errorTable.size()];
        this.errorTable.toArray(errors);
        return new MultiStatus("org.eclipse.ui.ide", 0, errors, DataTransferMessages.FileSystemExportOperation_problemsExporting, null);
    }

    protected void initialize() throws IOException {
        this.exporter = this.useTarFormat ? new TarFileExporter(this.destinationFilename, this.useCompression) : new ZipFileExporter(this.destinationFilename, this.useCompression);
    }

    protected boolean isDescendent(List resources, IResource child) {
        if (child.getType() == 4) {
            return false;
        }
        IContainer parent = child.getParent();
        if (resources.contains(parent)) {
            return true;
        }
        return this.isDescendent(resources, (IResource)parent);
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        this.monitor = progressMonitor;
        try {
            this.initialize();
        }
        catch (IOException e) {
            throw new InvocationTargetException(e, NLS.bind((String)DataTransferMessages.ZipExport_cannotOpen, (Object)e.getMessage()));
        }
        try {
            int totalWork = -1;
            try {
                totalWork = this.resourcesToExport == null ? this.countChildrenOf(this.resource) : this.countSelectedResources();
            }
            catch (CoreException coreException) {}
            this.monitor.beginTask(DataTransferMessages.DataTransfer_exportingTitle, totalWork);
            if (this.resourcesToExport == null) {
                this.exportResource(this.resource);
            } else {
                this.exportSpecifiedResources();
            }
            try {
                this.exporter.finished();
            }
            catch (IOException e) {
                throw new InvocationTargetException(e, NLS.bind((String)DataTransferMessages.ZipExport_cannotClose, (Object)e.getMessage()));
            }
        }
        finally {
            this.monitor.done();
        }
    }

    public void setCreateLeadupStructure(boolean value) {
        this.createLeadupStructure = value;
    }

    public void setUseCompression(boolean value) {
        this.useCompression = value;
    }

    public void setUseTarFormat(boolean value) {
        this.useTarFormat = value;
    }
}

