/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.recognition.arrimpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.ansj.domain.Nature;
import org.ansj.domain.NewWord;
import org.ansj.domain.Term;
import org.ansj.domain.TermNatures;
import org.ansj.recognition.TermArrRecognition;
import org.ansj.util.TermUtil;
import org.nlpcn.commons.lang.util.StringUtil;

public class ForeignPersonRecognition
implements TermArrRecognition {
    private static final LinkedList<NameChar> PRLIST = new LinkedList();
    private static NameChar INNAME = null;
    private static HashSet<Character> ISNOTFIRST = new HashSet();
    private List<Term> tempList = new ArrayList<Term>();
    private LinkedList<NameChar> prList = null;
    private Term[] terms = null;

    @Override
    public void recognition(Term[] terms) {
        this.terms = terms;
        String name = null;
        Term term = null;
        this.reset();
        for (int i = 0; i < terms.length; ++i) {
            if (terms[i] == null) continue;
            term = terms[i];
            if (this.tempList.size() == 0 && (term.termNatures().personAttr.end > 10 || terms[i].getName().length() == 1 && ISNOTFIRST.contains(Character.valueOf(terms[i].getName().charAt(0))))) continue;
            name = term.getName();
            if (term.termNatures() == TermNatures.NR || term.termNatures() == TermNatures.NW || name.length() == 1) {
                boolean flag = this.validate(name);
                if (!flag) continue;
                this.tempList.add(term);
                continue;
            }
            if (this.tempList.size() == 1) {
                this.reset();
                continue;
            }
            if (this.tempList.size() <= 1) continue;
            TermUtil.insertTerm(terms, this.tempList, TermNatures.NR);
            this.reset();
        }
    }

    private boolean validate(String name) {
        boolean flag = false;
        NameChar nameChar = null;
        for (int j = 0; j < this.prList.size(); ++j) {
            nameChar = this.prList.get(j);
            if (nameChar.contains(name)) {
                flag = true;
                continue;
            }
            this.prList.remove(j);
            --j;
        }
        return flag;
    }

    private void reset() {
        this.tempList.clear();
        this.prList = (LinkedList)PRLIST.clone();
    }

    public static boolean isFName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            if (INNAME.contains(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public List<NewWord> getNewWords(Term[] terms) {
        this.terms = terms;
        ArrayList<NewWord> all = new ArrayList<NewWord>();
        String name = null;
        Term term = null;
        this.reset();
        for (int i = 0; i < terms.length; ++i) {
            if (terms[i] == null) continue;
            term = terms[i];
            if (this.tempList.size() == 0 && (term.termNatures().personAttr.end > 10 || terms[i].getName().length() == 1 && ISNOTFIRST.contains(Character.valueOf(terms[i].getName().charAt(0))))) continue;
            name = term.getName();
            if (term.termNatures() == TermNatures.NR || term.termNatures() == TermNatures.NW || name.length() == 1) {
                boolean flag = this.validate(name);
                if (!flag) continue;
                this.tempList.add(term);
                continue;
            }
            if (this.tempList.size() == 1) {
                this.reset();
                continue;
            }
            if (this.tempList.size() <= 1) continue;
            StringBuilder sb = new StringBuilder();
            for (Term temp : this.tempList) {
                sb.append(temp.getName());
            }
            all.add(new NewWord(sb.toString(), Nature.NRF));
            this.reset();
        }
        return all;
    }

    public List<Term> getNewTerms() {
        LinkedList<Term> result = new LinkedList<Term>();
        String name = null;
        Term term = null;
        this.reset();
        for (int i = 0; i < this.terms.length; ++i) {
            if (this.terms[i] == null) continue;
            term = this.terms[i];
            if (this.tempList.size() == 0 && (term.termNatures().personAttr.end > 10 || this.terms[i].getName().length() == 1 && ISNOTFIRST.contains(Character.valueOf(this.terms[i].getName().charAt(0))))) continue;
            name = term.getName();
            if (term.termNatures() == TermNatures.NR || term.termNatures() == TermNatures.NW || name.length() == 1) {
                boolean flag = this.validate(name);
                if (!flag) continue;
                this.tempList.add(term);
                continue;
            }
            if (this.tempList.size() == 1) {
                this.reset();
                continue;
            }
            if (this.tempList.size() <= 1) continue;
            result.add(this.makeNewTerm());
            this.reset();
        }
        return result;
    }

    public Term makeNewTerm() {
        StringBuilder sb = new StringBuilder();
        int offe = this.tempList.get(0).getOffe();
        for (Term term : this.tempList) {
            sb.append(term.getName());
        }
        return new Term(sb.toString(), offe, TermNatures.NR);
    }

    static {
        NameChar trans_english = new NameChar(StringUtil.sortCharArray((String)"\u00b7-\u2014\u963f\u57c3\u827e\u7231\u5b89\u6602\u6556\u5965\u6fb3\u7b06\u82ad\u5df4\u767d\u62dc\u73ed\u90a6\u4fdd\u5821\u9c8d\u5317\u8d1d\u672c\u6bd4\u6bd5\u5f7c\u522b\u6ce2\u73bb\u535a\u52c3\u4f2f\u6cca\u535c\u5e03\u624d\u91c7\u4ed3\u67e5\u5dee\u67f4\u5f7b\u5ddd\u8328\u6148\u6b21\u8fbe\u5927\u6234\u4ee3\u4e39\u65e6\u4f46\u5f53\u9053\u5fb7\u5f97\u767b\u8fea\u72c4\u8482\u5e1d\u4e01\u4e1c\u675c\u6566\u591a\u989d\u4fc4\u5384\u9102\u6069\u5c14\u4f10\u6cd5\u8303\u83f2\u82ac\u8d39\u4f5b\u592b\u798f\u5f17\u752b\u5676\u76d6\u5e72\u5188\u54e5\u6208\u9769\u845b\u683c\u5404\u6839\u53e4\u74dc\u54c8\u6d77\u7f55\u7ff0\u6c57\u6c49\u8c6a\u5408\u6cb3\u8d6b\u4ea8\u4faf\u547c\u80e1\u534e\u970d\u57fa\u5409\u53ca\u52a0\u8d3e\u575a\u7b80\u6770\u91d1\u4eac\u4e45\u5c45\u541b\u5580\u5361\u51ef\u574e\u5eb7\u8003\u67ef\u79d1\u53ef\u514b\u80af\u5e93\u594e\u62c9\u5587\u83b1\u6765\u5170\u90ce\u6717\u52b3\u52d2\u96f7\u7d2f\u695e\u9ece\u7406\u674e\u91cc\u8389\u4e3d\u5386\u5229\u7acb\u529b\u8fde\u5ec9\u826f\u5217\u70c8\u6797\u9686\u5362\u864f\u9c81\u8def\u4f26\u4ed1\u7f57\u6d1b\u739b\u9a6c\u4e70\u9ea6\u8fc8\u66fc\u8305\u8302\u6885\u95e8\u8499\u76df\u7c73\u871c\u5bc6\u654f\u660e\u6469\u83ab\u58a8\u9ed8\u59c6\u6728\u7a46\u90a3\u5a1c\u7eb3\u4e43\u5948\u5357\u5185\u5c3c\u5e74\u6d85\u5b81\u7ebd\u52aa\u8bfa\u6b27\u5e15\u6f58\u7554\u5e9e\u57f9\u4f69\u5f6d\u76ae\u5e73\u6cfc\u666e\u5176\u5951\u6070\u5f3a\u4e54\u5207\u94a6\u6c81\u6cc9\u8ba9\u70ed\u8363\u8089\u5112\u745e\u82e5\u8428\u585e\u8d5b\u6851\u745f\u68ee\u838e\u6c99\u5c71\u5584\u7ecd\u820d\u5723\u65bd\u8bd7\u77f3\u4ec0\u53f2\u58eb\u5b88\u65af\u53f8\u4e1d\u82cf\u7d20\u7d22\u5854\u6cf0\u5766\u6c64\u5510\u9676\u7279\u63d0\u6c40\u56fe\u571f\u5410\u6258\u9640\u74e6\u4e07\u738b\u65fa\u5a01\u97e6\u7ef4\u9b4f\u6e29\u6587\u7fc1\u6c83\u4e4c\u543e\u6b66\u4f0d\u897f\u9521\u5e0c\u559c\u590f\u76f8\u9999\u6b47\u8c22\u8f9b\u65b0\u7259\u96c5\u4e9a\u5f66\u5c27\u53f6\u4f9d\u4f0a\u8863\u5b9c\u4e49\u56e0\u97f3\u82f1\u96cd\u5c24\u4e8e\u7ea6\u5bb0\u6cfd\u589e\u8a79\u73cd\u6cbb\u4e2d\u4ef2\u6731\u8bf8\u5353\u5b5c\u7956\u4f50\u4f3d\u5a05\u5c15\u8153\u6ed5\u6d4e\u5609\u6d25\u8d56\u83b2\u7433\u5f8b\u7565\u6155\u59ae\u8042\u88f4\u6d66\u5947\u9f50\u7434\u8339\u73ca\u536b\u6b23\u900a\u672d\u54f2\u667a\u5179\u8299\u6c76\u8fe6\u73c0\u742a\u68b5\u6590\u80e5\u9edb"));
        NameChar trans_russian = new NameChar(StringUtil.sortCharArray((String)"\u00b7-\u963f\u5b89\u5965\u5df4\u6bd4\u5f7c\u6ce2\u5e03\u5bdf\u8328\u5927\u5fb7\u5f97\u4e01\u675c\u5c14\u6cd5\u592b\u4f0f\u752b\u76d6\u683c\u54c8\u57fa\u52a0\u575a\u6377\u91d1\u5361\u79d1\u53ef\u514b\u5e93\u62c9\u83b1\u5170\u52d2\u96f7\u91cc\u5386\u5229\u8fde\u5217\u5362\u9c81\u7f57\u6d1b\u9a6c\u6885\u8499\u7c73\u59c6\u5a1c\u6d85\u5b81\u8bfa\u5e15\u6cfc\u666e\u5947\u9f50\u4e54\u5207\u65e5\u8428\u8272\u5c71\u7533\u4ec0\u65af\u7d22\u5854\u5766\u7279\u6258\u5a03\u7ef4\u6587\u4e4c\u897f\u5e0c\u8c22\u4e9a\u8036\u53f6\u4f9d\u4f0a\u4ee5\u624e\u4f50\u67f4\u8fbe\u767b\u8482\u6208\u679c\u6d77\u8d6b\u534e\u970d\u5409\u5b63\u6d25\u67ef\u7406\u7433\u739b\u66fc\u7a46\u7eb3\u5c3c\u5951\u94a6\u4e18\u6851\u6c99\u820d\u6cf0\u56fe\u74e6\u4e07\u96c5\u5353\u5179"));
        PRLIST.add(trans_english);
        PRLIST.add(trans_russian);
        INNAME = new NameChar(StringUtil.sortCharArray((String)"-\u00b7\u2014\u4e01\u4e07\u4e18\u4e1c\u4e1d\u4e2d\u4e39\u4e3d\u4e43\u4e45\u4e49\u4e4c\u4e54\u4e70\u4e8e\u4e9a\u4ea8\u4eac\u4ec0\u4ed1\u4ed3\u4ee3\u4ee5\u4ef2\u4f0a\u4f0d\u4f0f\u4f10\u4f26\u4f2f\u4f3d\u4f46\u4f50\u4f5b\u4f69\u4f9d\u4faf\u4fc4\u4fdd\u5112\u514b\u5170\u5176\u5179\u5185\u5188\u51ef\u5207\u5217\u5229\u522b\u529b\u52a0\u52aa\u52b3\u52c3\u52d2\u5317\u534e\u5353\u5357\u535a\u535c\u5361\u5362\u536b\u5384\u5386\u53ca\u53e4\u53ef\u53f2\u53f6\u53f8\u5404\u5408\u5409\u5410\u541b\u543e\u547c\u54c8\u54e5\u54f2\u5510\u5580\u5584\u5587\u559c\u5609\u5676\u56e0\u56fe\u571f\u5723\u574e\u575a\u5766\u57c3\u57f9\u57fa\u5821\u5854\u585e\u589e\u58a8\u58eb\u590f\u591a\u5927\u592b\u5947\u5948\u594e\u5951\u5965\u59ae\u59c6\u5a01\u5a03\u5a05\u5a1c\u5b5c\u5b63\u5b81\u5b88\u5b89\u5b9c\u5bb0\u5bc6\u5bdf\u5c14\u5c15\u5c24\u5c27\u5c3c\u5c45\u5c71\u5ddd\u5dee\u5df4\u5e03\u5e0c\u5e15\u5e1d\u5e72\u5e73\u5e74\u5e93\u5e9e\u5eb7\u5ec9\u5f17\u5f3a\u5f53\u5f66\u5f6d\u5f7b\u5f7c\u5f8b\u5f97\u5fb7\u6069\u6070\u6148\u6155\u6208\u6234\u624d\u624e\u6258\u62c9\u62dc\u6377\u63d0\u6469\u654f\u6556\u6566\u6587\u6590\u65af\u65b0\u65bd\u65e5\u65e6\u65fa\u6602\u660e\u666e\u667a\u66fc\u6717\u6728\u672c\u672d\u6731\u674e\u675c\u6765\u6770\u6797\u679c\u67e5\u67ef\u67f4\u6839\u683c\u6851\u6885\u68b5\u68ee\u695e\u6b21\u6b23\u6b27\u6b47\u6b66\u6bd4\u6bd5\u6c40\u6c49\u6c57\u6c64\u6c76\u6c81\u6c83\u6c99\u6cb3\u6cbb\u6cc9\u6cca\u6cd5\u6ce2\u6cf0\u6cfc\u6cfd\u6d1b\u6d25\u6d4e\u6d66\u6d77\u6d85\u6e29\u6ed5\u6f58\u6fb3\u70c8\u70ed\u7231\u7259\u7279\u72c4\u738b\u739b\u73bb\u73c0\u73ca\u73cd\u73ed\u7406\u742a\u7433\u7434\u745e\u745f\u74dc\u74e6\u752b\u7533\u7554\u7565\u767b\u767d\u76ae\u76d6\u76df\u76f8\u77f3\u7956\u798f\u79d1\u7a46\u7acb\u7b06\u7b80\u7c73\u7d20\u7d22\u7d2f\u7ea6\u7eb3\u7ebd\u7ecd\u7ef4\u7f55\u7f57\u7fc1\u7ff0\u8003\u8036\u8042\u8089\u80af\u80e1\u80e5\u8153\u820d\u826f\u8272\u827e\u8299\u82ac\u82ad\u82cf\u82e5\u82f1\u8302\u8303\u8305\u8328\u8339\u8363\u8389\u838e\u83ab\u83b1\u83b2\u83f2\u8428\u845b\u8482\u8499\u864f\u871c\u8863\u88f4\u897f\u8a79\u8ba9\u8bd7\u8bf8\u8bfa\u8c22\u8c6a\u8d1d\u8d39\u8d3e\u8d56\u8d5b\u8d6b\u8def\u8f9b\u8fbe\u8fc8\u8fde\u8fe6\u8fea\u900a\u9053\u90a3\u90a6\u90ce\u9102\u91c7\u91cc\u91d1\u94a6\u9521\u95e8\u963f\u9640\u9676\u9686\u96c5\u96cd\u96f7\u970d\u9769\u97e6\u97f3\u989d\u9999\u9a6c\u9b4f\u9c81\u9c8d\u9ea6\u9ece\u9ed8\u9edb\u9f50"));
        ISNOTFIRST.add(Character.valueOf('-'));
        ISNOTFIRST.add(Character.valueOf('\u00b7'));
        ISNOTFIRST.add(Character.valueOf('\u2014'));
    }

    private static class NameChar {
        private char[] chars = null;

        public NameChar(char[] chars) {
            this.chars = chars;
        }

        public boolean contains(String name) {
            return this.contains(name.charAt(0));
        }

        public boolean contains(char c) {
            return Arrays.binarySearch(this.chars, c) > -1;
        }
    }
}

